# -------------------------------------------------------------------------
#
# File:               INTSRV32.MAK
#
# Function:           Interactive Service Interface -- Makefile
#                     (for IBM C SET/2 Compiler)
#
# Author:             W. Reichert, D.3228
#
# Date created:       1992-07-20
#
# Classification:     IBM Internal Use Only
#
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# Here name all object files to be linked together
# (Add all your files containing INTSRV function declaration routines)
# -------------------------------------------------------------------------

OBJ =    ints_ini.obj ints_dos.obj ints_skl.obj ints_xxx.obj

# -------------------------------------------------------------------------
# Here name your own libraries containing the functions to be tested
# -------------------------------------------------------------------------
 
APPLIB =                        
 
# -------------------------------------------------------------------------
# Define compiler switches and inference rule
# -------------------------------------------------------------------------

LOPT   = /CO                                   # Link options
COPT   = /Ti /Ss /Q /Kbocgaper /C /Gm /Ge-     # Compiler options (DLL)
CXOPT  = /Ti /Ss /Q /Kbocgaper /C /Gm /Ge+     # Compiler options (EXE)
DLLLIB = ints_l32.lib intsrvpm.lib             # INTSRV libraries

.c.obj:                                             
       icc $(COPT) $*.c

# -------------------------------------------------------------------------
# Make INTSRV32.DLL
# -------------------------------------------------------------------------

ALL:  intsrv32.dll test

intsrv32.dll: $(OBJ) ints_l32.lib intsrv32.def
       link386 $(LOPT) $(OBJ),intsrv32.dll,nul,$(DLLLIB) $(APPLIB),\
       intsrv32.def;

intsrv32.lib: intsrv32.def
       implib intsrv32.lib intsrv32.def

# -------------------------------------------------------------------------
# Special dependencies:
# -------------------------------------------------------------------------

ints_ini.obj: $$(@B).c ints_ini.h intsrv32.mak
       icc $(COPT) $(FUNCS) $*.c
 
# -------------------------------------------------------------------------
# Make test programs 
#      TEST32.EXE:    for text window of fullscreen mode
#      TESTPM32.EXE:  multi-thread version for PM mode
# -------------------------------------------------------------------------

test: test32.exe testpm32.exe

test32.exe: $$(@B).obj intsrv32.lib test.def
       link386 $(LOPT) $*,$*.exe,nul,intsrv32.lib,test.def;

testpm32.exe: $$(@B).obj intsrv32.lib testpm.def
       link386 $(LOPT) $*,$*.exe,nul,intsrv32.lib,testpm.def;

test32.obj: test.c
       icc $(CXOPT) -Fotest32.obj test.c

testpm32.obj: testpm.c
       icc $(CXOPT) -Fotestpm32.obj testpm.c 
